/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspProcessorPool {
    private UnsignedInt8 mPoolId;
    private UnsignedInt16 mCurProcs;
    private UnsignedInt16 mPendProcs;
    private UnsignedInt32 mCurProcUnits;
    private UnsignedInt32 mPendProcUnits;
    private static final String GET_CURRENT_AND_PENDING_SHARED_PROCESSING_RESOURCES = "GET_CURRENT_AND_PENDING_SHARED_PROCESSING_RESOURCES";
    private static final String CURRENT_PROCS = "CURRENT_PROCS";
    private static final String CURRENT_PROC_UNITS = "CURRENT_PROC_UNITS";
    private static final String PENDING_PROCS = "PENDING_PROCS";
    private static final String PENDING_PROC_UNITS = "PENDING_PROC_UNITS";

    FspProcessorPool() {
    }

    FspProcessorPool getSharedProcessingResourcesCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt8 unsignedInt8) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_CURRENT_AND_PENDING_SHARED_PROCESSING_RESOURCES, new String[]{unsignedInt8.toString()});
        this.mPoolId = unsignedInt8;
        this.mCurProcs = (UnsignedInt16)hashtable.get(CURRENT_PROCS);
        this.mCurProcUnits = (UnsignedInt32)hashtable.get(CURRENT_PROC_UNITS);
        this.mPendProcs = (UnsignedInt16)hashtable.get(PENDING_PROCS);
        this.mPendProcUnits = (UnsignedInt32)hashtable.get(PENDING_PROC_UNITS);
        return this;
    }

    public UnsignedInt32 getCurAvailableProcUnits() {
        return this.mCurProcUnits;
    }

    public UnsignedInt16 getCurProcs() {
        return this.mCurProcs;
    }

    public UnsignedInt32 getPendAvailableProcUnits() {
        return this.mPendProcUnits;
    }

    public UnsignedInt16 getPendProcs() {
        return this.mPendProcs;
    }

    public UnsignedInt8 getPoolId() {
        return this.mPoolId;
    }

    public String toString() {
        return "PoolId=" + this.mPoolId + "; mCurProcs=" + this.mCurProcs + "; mPendProcs=" + this.mPendProcs + "; mCurProcUnits=" + this.mCurProcUnits + "; mPendProcUnits=" + this.mPendProcUnits;
    }
}

